/*
---------------------- Apache Version 2.0 License ----------------------
Copyright 2023 René Steger

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
------------------------------------------------------------------------
*/

-- create an instance of the Rexx class
rexxHandler=.RexxAppHandler~new
-- the abstract "start" method will be served by rexxHandler
rxApp=BSFCreateRexxProxy(rexxHandler, ,"javafx.application.Application")
-- launch the application and invokes "start"
rxApp~launch(rxApp~getClass, .nil)

-- get Java Support
::REQUIRES "BSF.CLS"

-- the Rexx handler for javafx.application.Application
::CLASS RexxAppHandler

-- will be called by JavaFX
::METHOD start
-- accesses the primary stage
USE ARG primaryStage

-- setting title to the Stage
primaryStage~setTitle("Sphere_CullFace")

-- import class Sphere
sphere=bsf.import("javafx.scene.shape.Sphere")
-- get access to cullFace
cuFa=bsf.loadClass("javafx.scene.shape.CullFace")

-- create the root node
root=.bsf~new("javafx.scene.Group")

-- create a sphere
sphere1=sphere~new
-- set the radius of the sphere
sphere1~radius=75
-- set position of the sphere
sphere1~translateX=150
sphere1~translateY=200
-- set the value of cullFace
sphere1~cullFace=cuFa~front

sphere2=sphere~new
sphere2~radius=75
sphere2~translateX=400
sphere2~translateY=200
sphere2~cullFace=cuFa~back

sphere3=sphere~new
sphere3~radius=75
sphere3~translateX=650
sphere3~translateY=200
sphere3~cullFace=cuFa~none

-- add the objects to the root node
root~getChildren~~add(sphere1)~~add(sphere2)~~add(sphere3)

-- create a scene and put it on the stage
primaryStage~setScene(.bsf~new("javafx.scene.Scene", root, 800, 400))
-- display the content of the stage
primaryStage~show